/*  Name: Gage Crowder
    Date: 04-28-15
    Course: ECE 4220
    Version: 2.2
    Desc: This software represents the code that runs the electronic throttle control (ETC) for the Mizzou FSAE formula car
*/

/* Required libraries */
#include <Servo.h>

/* Global variables */
int APPS1 = A2;                                      //Accelerator pedal position sensor 1 (analog pin 2)
int APPS2 = A3;                                      //Accelerator pedal position sensor 2 (analog pin 3)
int TPS1  = A4;                                      //Pedal position switch 1 (analog pin 4)
int TPS2  = A5;                                      //Pedal position switch 2 (analog pin 5)
int FP1   = 12;                                      //Fuel pump 1 (digital pin 12)
int BSE   = 3;                                       //Brake system encoder (digital pin 3)
Servo Throttle_Actuator;                             //Throttle actuator (servo object)

bool shutdown_flag = false;                          //Flag for system shutdown

/* Function that only runs once to set-up variables */
void setup() 
{
  Serial.begin(9600);                                //Set baud rate for serial communication
  
  /* Accelerator pedal position sensor pins */
  pinMode(APPS1, INPUT_PULLUP);                      //Set analog pin 2 (APPS1) for input
  pinMode(APPS2, INPUT_PULLUP);                      //Set analog pin 3 (APPS2) for input
  
  /* Throttle position sensor pins */
  pinMode(TPS1, INPUT_PULLUP);                       //Set analog pin 4 (TPS1) for input
  pinMode(TPS2, INPUT_PULLUP);                       //Set analog pin 5 (TPS2) for input
  
  /* Brake system encoder pin */
  pinMode(BSE, INPUT_PULLUP);                        //Set digital pin 3 (BSE) for input with 
  
  /* Fuel pump pin */
  pinMode(FP1, OUTPUT);                              //Set digital pin 12 (FP1) for output
  
  /* Interrupt pins and ISR attachment */
  pinMode(2, OUTPUT);                                //Set digital pin 2 (interrupt 0) for input pull-up resistor on
  
  digitalWrite(2, LOW);                              //Set digital pin 2 (interrupt 0) to low
  attachInterrupt(0, shutDownISR, RISING);           //Attach the interrupt handler to interrupt 0 triggered on the rising edge
  attachInterrupt(1, shutDownISR, FALLING);          //Attach the interrupt handler to interrupt 1 triggered on the falling edge
  
  /* Throttle actuator */
  Throttle_Actuator.attach(9);                       //Attach servo (throttle actuator) to digital pin 9
  
  /* Fuel pump initialize */
  Control_Fuel_Pump(true);                           //Set fuel pump to on
}

void loop() 
{
  
  /* Check if the program has been signaled for shutdown by the ISR */
  if(shutdown_flag == true)
  {
    actuate_Throttle(90);                            //Return to center position
    Control_Fuel_Pump(false);                        //Shutdown fuel pump
    Serial.println("System Shutdown");               //System shutdown message
    while(1);                                        //Force reset of program
  }
  
  /******************************** Accelerator Pedal **********************************/
  /* Read the pedal position sensors */
  int pedal_position_1 = analogRead(APPS1);          //Read pedal position sensor 1
  int pedal_position_2 = analogRead(APPS2);          //Read pedal position sensor 2
  
  /* Pedal position debug info */
  Serial.print("Accelerator Pedal 1: "); Serial.println(pedal_position_1);
  Serial.print("Accelerator Pedal 2: "); Serial.println(pedal_position_2);
  
  /* Get the average of the 2 sensor for the current pedal position */
  int current_pedal_position = (pedal_position_1 + pedal_position_2) / 2;
  
  /* Calculate the error between the 2 pedal position sensors */
  int pedal_error = abs(pedal_position_1 - pedal_position_2);
  
  /******************************** Throttle Position *************************************/  
  /* Read the throttle position sensors */
  int throttle_position_1 = analogRead(TPS1);         //Read throttle position sensor 1
  int throttle_position_2 = analogRead(TPS2);         //Read throttle position sensor 2
  
  /* Throttle Position debug info */
  Serial.print("Throttle Position 1: "); Serial.println(throttle_position_1);
  Serial.print("Throttle Position 2: "); Serial.println(throttle_position_2);
  
  /* Get the average of the 2 sensors for the current throttle position */
  int current_throttle_position = (throttle_position_1 + throttle_position_2) / 2;
  
  /* Calculate the error between the 2 throttle position sensors */
  int throttle_error = abs(throttle_position_2 - throttle_position_1);
  
  /******************************** Check Error ********************************************/
  /* If the error between either of the 2 sensors in either set is greater than 100 (apprx. 10%) shutdown the system */
  if(pedal_error > 100 || throttle_error > 100)
  {
    digitalWrite(2, HIGH);                                         //Set pin 2 to high (triggers shutdown ISR)
  }
  
  /* Actuate the throttle based on the sensor inputs */  
  int servo_pos = map(current_pedal_position, 0, 1023, 0, 179);    //Scale the input values 0-1023 to the output values 0-179
  actuate_Throttle(servo_pos);                                     //Actuate the throttle based on the scaled value
}

/* Inputs: The status of the fuel pump, a bool value
   Returns: None
   Purpose: To set the fuel pump control pin to either high or low (on or off) */
void Control_Fuel_Pump(bool fuel_pump_status)
{
  if(fuel_pump_status == true)
    digitalWrite(FP1, HIGH);                          //Turn fuel pump on
  else
    digitalWrite(FP1, LOW);                           //Turn fuel pump off
}

/* Inputs: None
   Returns: None
   Purpose: ISR that signals the system to shutdown*/
void shutDownISR()
{
   shutdown_flag = true;                              //Set shutdown flag to true
}

/* Inputs: The target throttle position
   Returns: None
   Purpose: To actuate the throttle servo to the correct position */
void actuate_Throttle(int target_position)
{
  Throttle_Actuator.write(target_position);           //Writes the throttle actuator (servo) to the correct position
}

